using System;
using System.Collections.Generic;
using System.Text;

namespace MulticastDemo
{
   class Program
   {
      delegate void MessagePrintDelegate(string s);

      static void Main(string[] args)
      {
         MessagePrintDelegate mpd1, mpd2, mpd3, mpd4;

         mpd1 = PrintMessage;
         mpd2 = PrintStampedMessage;

         // wykonaj kompozycj dwch delegatw
         mpd3 = mpd1 + mpd2;
         mpd3("Witaj wiecie");

         mpd4 = PrintMessage;
         mpd4 += mpd3;
         mpd4("Zgrupowane delegaty!");

         // moemy rwnie usun delegata z kompozycji
         mpd3 -= mpd1;
         mpd3("Witaj wiecie (ponownie)");

         // moemy skomponowa 2 delegaty zbiorowe
         mpd4 += mpd3;
         mpd4("Mocno zgrupowane delegaty");

         // moemy take doda metod anonimow do delegata zbiorowego
         mpd3 += delegate(string s)
         {
            Console.WriteLine("[Anonimowa] {0}", s);
         };
         mpd3("Witaj!");

         // moemy sprawdzi list metod dowolnego delegata zbiorowego
         Console.WriteLine("Metody w delegacie zbiorowym mpd3:");
         foreach (Delegate d in mpd3.GetInvocationList())
         {
            Console.WriteLine("\t{0}", d.Method.Name);
         }

         Console.ReadLine();
      }

      static void PrintMessage(string s)
      {
         Console.WriteLine(s);
      }

      static void PrintStampedMessage(string s)
      {
         Console.WriteLine("[{0}] {1}", DateTime.Now.ToShortTimeString(), s);
      }
   }
}
